<?php

namespace App\Http\Controllers;

use App\DataTables\ConsumableSettingsDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateConsumableSettingsRequest;
use App\Http\Requests\UpdateConsumableSettingsRequest;
use App\Http\Requests\AttachConsumableSettingsRequest;
use App\Repositories\ConsumableSettingsRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Models\ConsumableItem;
use App\Models\ConsumableSettingsDetail;

class ConsumableSettingsController extends AppBaseController
{
    /** @var  ConsumableSettingsRepository */
    private $consumableSettingsRepository;

    public function __construct(ConsumableSettingsRepository $consumableSettingsRepo)
    {
        $this->consumableSettingsRepository = $consumableSettingsRepo;
    }

    /**
     * Display a listing of the ConsumableSettings.
     *
     * @param ConsumableSettingsDataTable $consumableSettingsDataTable
     * @return Response
     */
    public function index(ConsumableSettingsDataTable $consumableSettingsDataTable)
    {      
        return $consumableSettingsDataTable->render('consumable_settings.index');
    }

    /**
     * Show the form for creating a new ConsumableSettings.
     *
     * @return Response
     */
    public function create()
    {
        $data = \App\Models\ConsumableCategory::pluck('name')->toArray();

        //dd($data);
        return view('consumable_settings.create')->with('categories', $data);
    }


    public function attachSettings($id)
    {
        $data = \App\Models\ConsumableCategory::pluck('name')->toArray();
        $settings = \App\Models\ConsumableSettings::find($id);

        //dd($data);
        return view('consumable_settings.attach')->with('categories', $data)->with('settings', $settings);
    }

    public function deleteSettings($id, AttachConsumableSettingsRequest $request)
    {
        $input = $request->all();
        $item = ConsumableSettingsDetail::find((int)$input['id']);
        if(!empty($item)){
            $item->forceDelete();
        }
        
        return $this->getSettings($id);
    }

    public function saveSettings($id, AttachConsumableSettingsRequest $request){
        $input = $request->all();
        //dd($input);
        $item = ConsumableItem::where('name->en', '=', $input['item'])->first();
        $obj = null;
        if(!empty($item)){
            $obj=ConsumableSettingsDetail::create([
                'consumable_id' => $id, 
                'item_id' => $item->id,
                'qty' => $input['qty'],
                'expected_pcs' => $input['expected_pcs'],
                'qty_type' => $input['qty_type'],
                'created_at' => \Carbon\Carbon::now()
            ]);
        }
        \App\Http\Resources\ConsumableSettingsDetailResource::withoutWrapping();
        return new \App\Http\Resources\ConsumableSettingsDetailResource($obj);
    }

    public function updateSettings($id, AttachConsumableSettingsRequest $request){
        $input = $request->all();
        //dd($input);
        $item = ConsumableItem::where('name->en', $input['item'])->first();
        $obj = null;
        if(!empty($item)){
            $detail = ConsumableSettingsDetail::find((int)$input['id']);
            $detail->update([
                'consumable_id' => $id, 
                'item_id' => $item->id,
                'qty' => $input['qty'],
                'expected_pcs' => $input['expected_pcs'],
                'qty_type' => $input['qty_type'],
                'updated_at' => \Carbon\Carbon::now()
            ]);
        }
        \App\Http\Resources\ConsumableSettingsDetailResource::withoutWrapping();
        return new \App\Http\Resources\ConsumableSettingsDetailResource($detail);
        
    }



    public function getSettings($id){
        $settings = ConsumableSettingsDetail::where('consumable_id','=', $id)->get();
        //\App\Http\Resources\ConsumableSettingsDetailResource::withoutWrapping();
        return \App\Http\Resources\ConsumableSettingsDetailResource::collection($settings);
        
    }

    /**
     * Store a newly created ConsumableSettings in storage.
     *
     * @param CreateConsumableSettingsRequest $request
     *
     * @return Response
     */
    public function store(CreateConsumableSettingsRequest $request)
    {
        $input = $request->all();

        $consumableSettings = $this->consumableSettingsRepository->create($input);

        Flash::success('Consumable Settings saved successfully.');

        return redirect(route('consumableSettings.index'));
    }

    /**
     * Display the specified ConsumableSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $consumableSettings = $this->consumableSettingsRepository->find($id);

        if (empty($consumableSettings)) {
            Flash::error('Consumable Settings not found');

            return redirect(route('consumableSettings.index'));
        }

        return view('consumable_settings.show')->with('consumableSettings', $consumableSettings);
    }

    /**
     * Show the form for editing the specified ConsumableSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $consumableSettings = $this->consumableSettingsRepository->find($id);

        if (empty($consumableSettings)) {
            Flash::error('Consumable Settings not found');

            return redirect(route('consumableSettings.index'));
        }

        return view('consumable_settings.edit')->with('consumableSettings', $consumableSettings);
    }


    

    /**
     * Update the specified ConsumableSettings in storage.
     *
     * @param  int              $id
     * @param UpdateConsumableSettingsRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateConsumableSettingsRequest $request)
    {
        $consumableSettings = $this->consumableSettingsRepository->find($id);

        if (empty($consumableSettings)) {
            Flash::error('Consumable Settings not found');

            return redirect(route('consumableSettings.index'));
        }

        $consumableSettings = $this->consumableSettingsRepository->update($request->all(), $id);

        Flash::success('Consumable Settings updated successfully.');

        return redirect(route('consumableSettings.index'));
    }

    /**
     * Remove the specified ConsumableSettings from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $consumableSettings = $this->consumableSettingsRepository->find($id);

        if (empty($consumableSettings)) {
            Flash::error('Consumable Settings not found');

            return redirect(route('consumableSettings.index'));
        }

        $this->consumableSettingsRepository->delete($id);

        Flash::success('Consumable Settings deleted successfully.');

        return redirect(route('consumableSettings.index'));
    }
}
