<?php

namespace App\DataTables;

use App\Models\ConsumableCategory;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class ConsumableCategoryDataTable extends DataTable
{
    var $isDeleted;

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $dataTable->addColumn('name', function (ConsumableCategory $album) {
            return $album->getTranslations('name')['en'];
        });

        $dataTable->addColumn('name', function (ConsumableCategory $album) {
            return $album->getTranslations('name')['en'];
        });


        return $dataTable->addColumn('action', 'consumable_categories.datatables_actions');
    }

    public function setDeleted($deleted){
        $this->isDeleted = $deleted;
    }

    public function getDeletedItem(){
        return ConsumableCategory::onlyTrashed();
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\ConsumableCategory $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(ConsumableCategory $model)
    {
        return $query = $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->addAction(['width' => '120px', 'printable' => false])
            ->parameters([
                'dom'       => 'Bfrtip',
                'stateSave' => true,
                'order'     => [[0, 'desc']],
                'buttons'   => [
                    ['extend' => 'create', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'export', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-default btn-sm no-corner',],
                ],
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'name'
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'consumable_categoriesdatatable_' . time();
    }
}
