<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('group_id')->nullable(false);  
            $table->string('name')->nullable(false)->unique();
            //$table->string('code')->nullable()->unique();
            $table->decimal('balance_cr', 25 ,2)->default(0);  
            $table->decimal('balance_dr', 25 , 2)->default(0);  
            $table->char('type', 1)->nullable(false)->default('0'); 
            $table->boolean('reconciliation')->default(false); 
            //$table->string('notes', 500)->nullable(true);
            $table->string('phoneNo', 15)->nullable(true);  
            $table->string('email')->nullable(true);  
            $table->string('gstNo')->nullable(true);  
            $table->string('billing_address')->nullable(true);  
            $table->string('shipping_address')->nullable(true);  

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();

            $table->foreign('group_id')->references('id')->on('account_groups');
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');
           // $table->foreign('deleted_by')->references('id')->on('users');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('accounts');
    }
}
