<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumableSettingsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consumable_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            //$table->softDeletes();
            $table->string('name');
            $table->string('description')->nullable(true);
            $table->string('alias');
            $table->enum('type', ['COLDPRESS_DIE','PATTI','THERMOCOUPLE','MOULD','PACKING','BEAD_RUBBER_COATING','BEAD_PLASTIC_COATING','GRINDING','FINISHING','HOT_PRESS_ACCESSORIES','COLD_PRESS_ACCESSORIES','BINDER','OTHER']);
            $table->decimal('qty', 25, 2)->nullable(true);
            $table->enum('qty_type', ['PERCENTAGE','UNIT'])->nullable(true);

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            $table->foreign('deleted_by')->references('id')->on('users');     
        });

        Schema::table('bond_material_recipes', function (Blueprint $table) {
            $table->foreign('packing_settings_id')->references('id')->on('consumable_settings');  
            $table->foreign('finishing_settings_id')->references('id')->on('consumable_settings');  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('mould_settings');
    }
}
