<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\AccountGroup;

class UpdateAccountGroupRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        AccountGroup::$rules['name'] = 'required|unique:account_groups,name,'.$this->segment(3).',id';
        AccountGroup::$rules['code'] = 'required|unique:account_groups,code,'.$this->segment(3).',id';
        return AccountGroup::$rules;
    }
}
