<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class PasswordExpiredRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'current_password' => 'required',
            'password' => 'required|confirmed|min:6|regex:/^.*(?=.{3,})(?=.*[a-zA-Z])(?=.*[0-9])(?=.*[\d\X])(?=.*[!$#%@]).*$/',
            'CaptchaCode' => 'required|valid_captcha'
        ];
    }

    public function messages()
    {
        return [
            'password.regex' => 'Password must contain atleast 6 chat with 1 capital , 1 small and 1 number and 1 special character'
        ];
    }
}