<?php

namespace App\Http\Controllers;

use App\DataTables\ConsumableCategoryDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateConsumableCategoryRequest;
use App\Http\Requests\UpdateConsumableCategoryRequest;
use App\Repositories\ConsumableCategoryRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class ConsumableCategoryController extends AppBaseController
{
    /** @var  ConsumableCategoryRepository */
    private $consumableCategoryRepository;

    public function __construct(ConsumableCategoryRepository $consumableCategoryRepo)
    {
        $this->consumableCategoryRepository = $consumableCategoryRepo;
    }

    /**
     * Display a listing of the ConsumableCategory.
     *
     * @param ConsumableCategoryDataTable $consumableCategoryDataTable
     * @return Response
     */
    public function index(ConsumableCategoryDataTable $consumableCategoryDataTable)
    {
        return $consumableCategoryDataTable->render('consumable_categories.index');
    }


    public function indexDeleted(ConsumableCategoryDataTable $consumableCategoryDataTable)
    {
        $consumableCategoryDataTable->setDeleted(true);
        return $consumableCategoryDataTable->render('consumable_categories.index');
    }

    /**
     * Show the form for creating a new ConsumableCategory.
     *
     * @return Response
     */
    public function create()
    {
        return view('consumable_categories.create');
    }

    /**
     * Store a newly created ConsumableCategory in storage.
     *
     * @param CreateConsumableCategoryRequest $request
     *
     * @return Response
     */
    public function store(CreateConsumableCategoryRequest $request)
    {
        $input = $request->all();

        $consumableCategory = $this->consumableCategoryRepository->create($input);

        Flash::success('Consumable Category saved successfully.');

        return redirect(route('consumableCategories.index'));
    }

    /**
     * Display the specified ConsumableCategory.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $consumableCategory = $this->consumableCategoryRepository->find($id);

        if (empty($consumableCategory)) {
            Flash::error('Consumable Category not found');

            return redirect(route('consumableCategories.index'));
        }

        return view('consumable_categories.show')->with('consumableCategory', $consumableCategory);
    }

    /**
     * Show the form for editing the specified ConsumableCategory.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $consumableCategory = $this->consumableCategoryRepository->find($id);

        if (empty($consumableCategory)) {
            Flash::error('Consumable Category not found');

            return redirect(route('consumableCategories.index'));
        }

        return view('consumable_categories.edit')->with('consumableCategory', $consumableCategory);
    }

    /**
     * Update the specified ConsumableCategory in storage.
     *
     * @param  int              $id
     * @param UpdateConsumableCategoryRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateConsumableCategoryRequest $request)
    {
        $consumableCategory = $this->consumableCategoryRepository->find($id);

        if (empty($consumableCategory)) {
            Flash::error('Consumable Category not found');

            return redirect(route('consumableCategories.index'));
        }

        $consumableCategory = $this->consumableCategoryRepository->update($request->all(), $id);

        Flash::success('Consumable Category updated successfully.');

        return redirect(route('consumableCategories.index'));
    }

    /**
     * Remove the specified ConsumableCategory from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $consumableCategory = $this->consumableCategoryRepository->find($id);

        if (empty($consumableCategory)) {
            Flash::error('Consumable Category not found');

            return redirect(route('consumableCategories.index'));
        }

        $this->consumableCategoryRepository->delete($id);

        Flash::success('Consumable Category deleted successfully.');

        return redirect(route('consumableCategories.index'));
    }
}
