<?php

namespace App\DataTables;

use App\Models\BondProcessParams;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class BondProcessParamsDataTable extends BaseDataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $dataTable->addColumn('consumable_settings', function (BondProcessParams $album) {
            return parent::getString($album->consumableSettings()->pluck('name')->toArray());
        });

        $dataTable->addColumn('action', 'bond_process_params.datatables_actions');

        $dataTable->rawColumns(['action', 'consumable_settings']);
        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\BondProcessParams $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(BondProcessParams $model)
    {
        return $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->addAction(['width' => '120px', 'printable' => false])
            ->parameters([
                'dom'       => 'Bfrtip',
                'stateSave' => true,
                'order'     => [[0, 'desc']],
                "autoWidth" =>  false,
                'buttons'   => [
                    ['extend' => 'create', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'export', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-default btn-sm no-corner',],
                ],
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
           'name' => [ 'width' => '100px'],
           'proc_type' => [ 'width' => '50px'],
           'consumable_settings' => [ 'width' => '100px'], 
           'cycle_time' => [ 'width' => '100px'], 
           'expected_mould'
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'bond_process_paramsdatatable_' . time();
    }
}
