<?php

use Illuminate\Database\Seeder;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /*
         * Permission Types
         *
         */
        $Permissionitems = [
            [
                'name'        => 'Can View Users',
                'slug'        => 'view.users',
                'description' => 'Can view users',
                'model'       => 'Permission',
            ],
            [
                'name'        => 'Can Create Users',
                'slug'        => 'create.users',
                'description' => 'Can create new users',
                'model'       => 'Permission',
            ],
            [
                'name'        => 'Can Edit Users',
                'slug'        => 'edit.users',
                'description' => 'Can edit users',
                'model'       => 'Permission',
            ],
            [
                'name'        => 'Can Delete Users',
                'slug'        => 'delete.users',
                'description' => 'Can delete users',
                'model'       => 'Permission',
            ],
            [
                'name'        => 'Can Create Material',
                'slug'        => 'create.bond_material_recipes',
                'description' => 'Can Create Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'Can Update Material',
                'slug'        => 'update.bond_material_recipes',
                'description' => 'Can Update Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'Can Delete Material',
                'slug'        => 'delete.bond_material_recipes',
                'description' => 'Can Update Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'View Material',
                'slug'        => 'view.bond_material_recipes',
                'description' => 'Can View Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'List Material',
                'slug'        => 'list.bond_material_recipes',
                'description' => 'Can Update Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'Report Material',
                'slug'        => 'report.bond_material_recipes',
                'description' => 'Report Material',
                'model'       => 'BondMaterialRecipe',
            ],
            [
                'name'        => 'Sensitive information',
                'slug'        => 'view.sensitive',
                'description' => 'View Sensitive Information',
                'model'       => 'SensitiveInfo',
            ],
            [
                'name'        => 'Can Create Production',
                'slug'        => 'create.bond_recipe_productions',
                'description' => 'Can Create Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'Can Update Production',
                'slug'        => 'update.bond_recipe_productions',
                'description' => 'Can Update Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'Can Delete Production',
                'slug'        => 'delete.bond_recipe_productions',
                'description' => 'Can Delete Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'View Production',
                'slug'        => 'view.bond_recipe_productions',
                'description' => 'Can View Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'List Production',
                'slug'        => 'list.bond_recipe_productions',
                'description' => 'Can List Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'Limited List Production',
                'slug'        => 'limitlist.bond_recipe_productions',
                'description' => 'Can limited List Production',
                'model'       => 'BondRecipeProduction',
            ],
            [
                'name'        => 'Report Production',
                'slug'        => 'report.bond_recipe_productions',
                'description' => 'Report Production',
                'model'       => 'BondRecipeProduction',
            ],



            [
                'name'        => 'Can Create QualityCheck',
                'slug'        => 'create.quality_checks',
                'description' => 'Can Create QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'Can Update QualityCheck',
                'slug'        => 'update.quality_checks',
                'description' => 'Can Update QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'Can Delete QualityCheck',
                'slug'        => 'delete.quality_checks',
                'description' => 'Can Delete QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'View QualityCheck',
                'slug'        => 'view.quality_checks',
                'description' => 'Can View QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'List QualityCheck',
                'slug'        => 'list.quality_checks',
                'description' => 'Can List QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'Limited List QualityCheck',
                'slug'        => 'limitlist.quality_checks',
                'description' => 'Can List QualityCheck',
                'model'       => 'QualityCheck',
            ],
            [
                'name'        => 'Report QualityCheck',
                'slug'        => 'report.quality_checks',
                'description' => 'Report QualityCheck',
                'model'       => 'QualityCheck',
            ],


            [
                'name'        => 'Create Packaging',
                'slug'        => 'create.production_packagings',
                'description' => 'Can Create Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Update Packaging',
                'slug'        => 'update.production_packagings',
                'description' => 'Can Update PackPackaginging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Delete Packaging',
                'slug'        => 'delete.production_packagings',
                'description' => 'Can Delete Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'View Packaging',
                'slug'        => 'view.production_packagings',
                'description' => 'Can View Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'List Packaging',
                'slug'        => 'list.production_packagings',
                'description' => 'Can List Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Limited Packaging',
                'slug'        => 'limitlist.production_packagings',
                'description' => 'Can List Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Report Packaging',
                'slug'        => 'report.production_packagings',
                'description' => 'Report Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Merge Packaging',
                'slug'        => 'merge.production_packagings',
                'description' => 'Merge Packaging',
                'model'       => 'ProductionPackaging',
            ],
            [
                'name'        => 'Divide Packaging',
                'slug'        => 'divide.production_packagings',
                'description' => 'Divide Packaging',
                'model'       => 'ProductionPackaging',
            ],



            [
                'name'        => 'Create Consumpation',
                'slug'        => 'create.consumable_consumpations',
                'description' => 'Can Create Consumpation',
                'model'       => 'ConsumableConsumpation',
            ],
            [
                'name'        => 'Update Consumpation',
                'slug'        => 'update.consumable_consumpations',
                'description' => 'Can Update Consumpation',
                'model'       => 'ConsumableConsumpation',
            ],
            [
                'name'        => 'Delete Consumpation',
                'slug'        => 'delete.consumable_consumpations',
                'description' => 'Can Delete Consumpation',
                'model'       => 'ConsumableConsumpation',
            ],
            [
                'name'        => 'View Consumpation',
                'slug'        => 'view.consumable_consumpations',
                'description' => 'Can View Consumpation',
                'model'       => 'ConsumableConsumpation',
            ],
            [
                'name'        => 'List Consumpation',
                'slug'        => 'list.consumable_consumpations',
                'description' => 'Can List Consumpation',
                'model'       => 'ConsumableConsumpation',
            ],


            [
                'name'        => 'Create Accounts',
                'slug'        => 'create.accounts',
                'description' => 'Can Create Accounts',
                'model'       => 'Account',
            ],
            [
                'name'        => 'Update Accounts',
                'slug'        => 'update.accounts',
                'description' => 'Can Update Accounts',
                'model'       => 'Account',
            ],
            [
                'name'        => 'Delete Accounts',
                'slug'        => 'delete.accounts',
                'description' => 'Can Delete Accounts',
                'model'       => 'Account',
            ],
            [
                'name'        => 'View Accounts',
                'slug'        => 'view.accounts',
                'description' => 'Can View Accounts',
                'model'       => 'Account',
            ],
            [
                'name'        => 'List Accounts',
                'slug'        => 'list.accounts',
                'description' => 'Can List Accounts',
                'model'       => 'Account',
            ],


            [
                'name'        => 'Create Invoice',
                'slug'        => 'create.invoices',
                'description' => 'Can Create Invoice',
                'model'       => 'Invoice',
            ],
            [
                'name'        => 'Update Invoice',
                'slug'        => 'update.invoices',
                'description' => 'Can Update Invoice',
                'model'       => 'Invoice',
            ],
            [
                'name'        => 'Delete Invoice',
                'slug'        => 'delete.invoices',
                'description' => 'Can Delete Invoices',
                'model'       => 'Invoice',
            ],
            [
                'name'        => 'View Invoice',
                'slug'        => 'view.invoices',
                'description' => 'Can View Invoices',
                'model'       => 'Invoice',
            ],
            [
                'name'        => 'List Invoice',
                'slug'        => 'list.invoices',
                'description' => 'Can List invoices',
                'model'       => 'Invoice',
            ],

            [
                'name'        => 'Create Entry',
                'slug'        => 'create.entries',
                'description' => 'Can Create Entry',
                'model'       => 'Entry',
            ],
            [
                'name'        => 'Update Entry',
                'slug'        => 'update.entries',
                'description' => 'Can Update Entry',
                'model'       => 'Entry',
            ],
            [
                'name'        => 'Delete Entry',
                'slug'        => 'delete.entries',
                'description' => 'Can Delete Entry',
                'model'       => 'Entry',
            ],
            [
                'name'        => 'View Entry',
                'slug'        => 'view.entries',
                'description' => 'Can View Entry',
                'model'       => 'Entry',
            ],
            [
                'name'        => 'List Entry',
                'slug'        => 'list.entries',
                'description' => 'Can List Entry',
                'model'       => 'Entry',
            ],


            

            
        ];

        /*
         * Add Permission Items
         *
         */
        foreach ($Permissionitems as $Permissionitem) {
            $newPermissionitem = config('roles.models.permission')::where('slug', '=', $Permissionitem['slug'])->first();
            if ($newPermissionitem === null) {
                $newPermissionitem = config('roles.models.permission')::create([
                    'name'          => $Permissionitem['name'],
                    'slug'          => $Permissionitem['slug'],
                    'description'   => $Permissionitem['description'],
                    'model'         => $Permissionitem['model'],
                ]);
            }
        }
    }
}
