<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductionStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_status', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('tag');
            $table->timestamps();
        });

        Schema::table('bond_recipe_production_status', function (Blueprint $table) {
            $table->foreign('status_id')->references('id')->on('production_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production_status');
    }
}
