<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ConsumableSettings
 * @package App\Models
 * @version October 19, 2019, 5:34 pm UTC
 *
 */
class ConsumableSettings extends CRUDAwareModel
{
    //use SoftDeletes;

    public $table = 'consumable_settings';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'description',
        'type',
        'qty',
        'qty_type',
        'alias'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'qty' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name.*' => 'required|unique_translation:consumable_settings',
        'qty' => 'nullable|numeric',
        'alias' => 'required'
    ];

    public function items(){
        return $this->hasMany('App\Models\ConsumableSettingsDetail','consumable_id');
    } 
}
