<?php

namespace App\Http\Controllers;

use App\DataTables\BondRecipeProductionDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondRecipeProductionRequest;
use App\Http\Requests\UpdateBondRecipeProductionRequest;
use App\Repositories\BondRecipeProductionRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Log;

class BondRecipeProductionController extends AppBaseController
{
    /** @var  BondRecipeProductionRepository */
    private $bondRecipeProductionRepository;

    public function __construct(BondRecipeProductionRepository $bondRecipeProductionRepo)
    {
        $this->bondRecipeProductionRepository = $bondRecipeProductionRepo;
    }

    /**
     * Display a listing of the BondRecipeProduction.
     *
     * @param BondRecipeProductionDataTable $bondRecipeProductionDataTable
     * @return Response
     */
    public function index(BondRecipeProductionDataTable $bondRecipeProductionDataTable)
    {
        return $bondRecipeProductionDataTable->render('bond_recipe_productions.index');
    }

    /**
     * Show the form for creating a new BondRecipeProduction.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_recipe_productions.create');
    }

    /**
     * Store a newly created BondRecipeProduction in storage.
     *
     * @param CreateBondRecipeProductionRequest $request
     *
     * @return Response
     */
    public function store(CreateBondRecipeProductionRequest $request)
    {
        $input = $request->all();

        $this->updateData($input);

        Log::info('input data '.json_encode($input));

       // dd($input);

        $bondRecipeProduction = $this->bondRecipeProductionRepository->create($input);

        $status = \App\Models\BondRecipeProductionStatus::where('material_id','=', $bondRecipeProduction->material_id)->orderBy('created_at','DESC')->first();
        Log::info('status '.$status->status->name);
        if($status->status->tag == 'READY_FOR_PRODUCTION' || $status->status->tag == 'STOPPED'){
            \App\Models\BondRecipeProductionStatus::updateProductionStatus($bondRecipeProduction->material_id ,'STARTED');
        }
       

        if($request->expectsJson()){
            return  $this->sendResponse(new \App\Http\Resources\Production\BondMaterialProductionResource($bondRecipeProduction),'Bond Production created sucessfully.');
        }else{
            Flash::success('Bond Recipe Production saved successfully.');
            return redirect(route('bondRecipeProductions.index'));
        }
    }

    /**
     * Display the specified BondRecipeProduction.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id, Request $request)
    {
        $bondRecipeProduction = $this->bondRecipeProductionRepository->find($id);

        $this->checkEmpty($bondRecipeProduction, $request);

        if($request->expectsJson()){
            return  $this->sendDataResponse(new \App\Http\Resources\Production\BondMaterialProductionResource($bondRecipeProduction));
        }else{
            return view('bond_recipe_productions.show')->with('bondRecipeProduction', $bondRecipeProduction);
        }

        
    }

    private function updateData(& $input){
        Log::info('start_time '.$input['start_time']);
        Log::info('end_time '.$input['end_time']);
        $startTime = Carbon::createFromFormat('d-m-Y g:i a', $input['start_time']);
        $endTime = Carbon::createFromFormat('d-m-Y g:i a', $input['end_time']);
        Log::info('start_time1 '.$startTime);
        Log::info('end_time1 '.$endTime);
        // $stime = Carbon::createFromTimestampMs($startTime);
        // $etime = Carbon::createFromTimestampMs($endTime);
        // Log::info('start_time2 '.$stime);
        // Log::info('end_time2 '.$etime);
        $input['duration'] = ($endTime->diffInSeconds($startTime))*1000;
       // Log::info('diff for humens '.$endTime->diffForHumans($startTime));
        //Log::info('duration '.$input['duration']);
        //$input['net_qty'] = $input['qty'] + $input['rejection_under_size_qty'] + $input['rejection_over_size_qty'] + $input['rejection_shape_qty'];
    }

    

    /**
     * Show the form for editing the specified BondRecipeProduction.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id, Request $request)
    {
        $bondRecipeProduction = $this->bondRecipeProductionRepository->find($id);

        $this->checkEmpty($bondRecipeProduction, $request);

        
        return view('bond_recipe_productions.edit')->with('bondRecipeProduction', $bondRecipeProduction);
    }

    /**
     * Update the specified BondRecipeProduction in storage.
     *
     * @param  int              $id
     * @param UpdateBondRecipeProductionRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondRecipeProductionRequest $request)
    {
        $bondRecipeProduction = $this->bondRecipeProductionRepository->find($id);

        $this->checkEmpty($bondRecipeProduction, $request);

        $input = $request->all();
        Log::info('input before data '.json_encode($input));
        $this->updateData($input);
        Log::info('input after data '.json_encode($input));
        $bondRecipeProduction = $this->bondRecipeProductionRepository->update($input, $id);

       // $this->updateStatus($bondRecipeProduction, $input['status']);

        if($request->expectsJson()){
            return  $this->sendResponse(new \App\Http\Resources\Production\BondMaterialProductionResource($bondRecipeProduction), "Bond Production updated sucessfully.");
        }else{
            Flash::success('Bond Production updated successfully.');

            return redirect(route('bondRecipeProductions.index'));
        }
        
    }

    /**
     * Remove the specified BondRecipeProduction from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id, Request $request)
    {
        $bondRecipeProduction = $this->bondRecipeProductionRepository->find($id);

        $this->checkEmpty($bondRecipeProduction, $request);

        $this->bondRecipeProductionRepository->delete($id);

        if($request->expectsJson()){
            return  $this->sendResponseMessage('Bond Production deleted successfully.');;
        }else{
            Flash::success('Bond Recipe Production deleted successfully.');

            return redirect(route('bondRecipeProductions.index'));
        }

       
    }

    private function  checkEmpty($bondMaterialRecipe , $request){
        if (empty($bondMaterialRecipe)){
            if($request->expectsJson()){
                return $this->sendValidationError('Bond Recipe Production not found');
            }else{
                Flash::error('Bond Recipe Production not found');
                return redirect(route('bondRecipeProductions.index'));
            }
        }
    }
}
