<?php

namespace App\Http\Controllers;

use App\DataTables\BondInvoiceDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondInvoiceRequest;
use App\Http\Requests\UpdateBondInvoiceRequest;
use App\Repositories\BondInvoiceRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class BondInvoiceController extends AppBaseController
{
    /** @var  BondInvoiceRepository */
    private $bondInvoiceRepository;

    public function __construct(BondInvoiceRepository $bondInvoiceRepo)
    {
        $this->bondInvoiceRepository = $bondInvoiceRepo;
    }

    /**
     * Display a listing of the BondInvoice.
     *
     * @param BondInvoiceDataTable $bondInvoiceDataTable
     * @return Response
     */
    public function index(BondInvoiceDataTable $bondInvoiceDataTable)
    {
        return $bondInvoiceDataTable->render('bond_invoices.index');
    }

    /**
     * Show the form for creating a new BondInvoice.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_invoices.create');
    }

    /**
     * Store a newly created BondInvoice in storage.
     *
     * @param CreateBondInvoiceRequest $request
     *
     * @return Response
     */
    public function store(CreateBondInvoiceRequest $request)
    {
        $input = $request->all();

        $bondInvoice = $this->bondInvoiceRepository->create($input);

        Flash::success('Bond Invoice saved successfully.');

        return redirect(route('bondInvoices.index'));
    }

    /**
     * Display the specified BondInvoice.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bondInvoice = $this->bondInvoiceRepository->find($id);

        if (empty($bondInvoice)) {
            Flash::error('Bond Invoice not found');

            return redirect(route('bondInvoices.index'));
        }

        return view('bond_invoices.show')->with('bondInvoice', $bondInvoice);
    }

    /**
     * Show the form for editing the specified BondInvoice.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bondInvoice = $this->bondInvoiceRepository->find($id);

        if (empty($bondInvoice)) {
            Flash::error('Bond Invoice not found');

            return redirect(route('bondInvoices.index'));
        }

        return view('bond_invoices.edit')->with('bondInvoice', $bondInvoice);
    }

    /**
     * Update the specified BondInvoice in storage.
     *
     * @param  int              $id
     * @param UpdateBondInvoiceRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondInvoiceRequest $request)
    {
        $bondInvoice = $this->bondInvoiceRepository->find($id);

        if (empty($bondInvoice)) {
            Flash::error('Bond Invoice not found');

            return redirect(route('bondInvoices.index'));
        }

        $bondInvoice = $this->bondInvoiceRepository->update($request->all(), $id);

        Flash::success('Bond Invoice updated successfully.');

        return redirect(route('bondInvoices.index'));
    }

    /**
     * Remove the specified BondInvoice from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bondInvoice = $this->bondInvoiceRepository->find($id);

        if (empty($bondInvoice)) {
            Flash::error('Bond Invoice not found');

            return redirect(route('bondInvoices.index'));
        }

        $this->bondInvoiceRepository->delete($id);

        Flash::success('Bond Invoice deleted successfully.');

        return redirect(route('bondInvoices.index'));
    }
}
