<?php
namespace App\Http\Controllers\API;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Http\Resources\User\UserResource;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Log;
use Carbon\Carbon;
use App\Repositories\BondRecipeProductionRepository;
/**
 * Class DemoController
 * @package App\Http\Controllers\API
 */

class ProductionAPIController extends AppBaseController
{
    /** @var  BondRecipeProductionRepository */
    private $bondRecipeProductionRepository;

    public function __construct(BondRecipeProductionRepository $bondRecipeProductionRepo)
    {
        $this->bondRecipeProductionRepository = $bondRecipeProductionRepo;
    }

    public function listProduction(Request $request){
        $query = $request->get('query');
        $bondMaterialRecipe =null;
        $user = Auth::user();
        if ($user->hasPermission('limitlist.bondrecipeproductions')) { // you can pass an id or slug
            $bondMaterialRecipe = \App\Models\BondRecipeProduction::orderBy('created_at','DESC')->where('created_by',$user->id)->take(config('app_data.limit_list_count'))->get();
            return  new \App\Http\Resources\LimitlistPaginationResourceCollection($bondMaterialRecipe, \App\Http\Resources\Production\BondMaterialProductionResource::class);      
        }else if($user->hasPermission('list.bondrecipeproductions')){
            if(!empty($query)){
                $bondMaterialRecipe = \App\Models\BondRecipeProduction::where('material_id','like', '%'.$query.'%')->orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
            }else{
                $bondMaterialRecipe = \App\Models\BondRecipeProduction::orderBy('created_at','DESC')->paginate(config('app_data.per_page_data'));
            }
        }else{
            return $this->sendValidationError('Access denied, please contact to admin');
        }
        return  new \App\Http\Resources\BasePaginationResourceCollection($bondMaterialRecipe, collect($bondMaterialRecipe->items()), \App\Http\Resources\Production\BondMaterialProductionResource::class);
    }

}

