<?php
namespace App\Http\Controllers\API;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Http\Resources\User\UserResource;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Log;
use Carbon\Carbon;
/**
 * Class DemoController
 * @package App\Http\Controllers\API
 */

class MiniAPIController extends AppBaseController
{
    public function getBondProcessNames(){
        $bondProcess = \App\Models\BondProcessParams::orderBy('created_at', 'DESC')->get();
        return \App\Http\Resources\Mini\MiniBondProcessResource::collection($bondProcess);
    }

    public function getBondNames(){
        $bondProcess = \App\Models\Bond::where('status','ACTIVE')->orderBy('created_at', 'DESC')->get();
        return \App\Http\Resources\Mini\MiniBondResource::collection($bondProcess) ;
    }
}

