<?php

namespace App\DataTables;

use App\Models\EntryTag;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class EntryTagDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $dataTable->addColumn('background_color', function (EntryTag $album) {
            return "<div style='min-height:100%; background-color:".$album->background_color.";' width='50px' height='100px' >'.$album->background_color.'</div>";
            //return "<span class='label label-default'>".$album->background_color."</span>";
        });

        $dataTable->addColumn('color', function (EntryTag $album) {
            return "<div style='min-height:100%; background-color:".$album->color.";' width='50px' height='100px' >'.$album->color.'</div>";
        });

        $dataTable->addColumn('action', 'bond_process_params.datatables_actions');

        $dataTable->rawColumns(['action', 'background_color','color']);


        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\EntryTag $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(EntryTag $model)
    {
        return $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->addAction(['width' => '120px', 'printable' => false])
            ->parameters([
                'dom'       => 'Bfrtip',
                'stateSave' => true,
                'order'     => [[0, 'desc']],
                'buttons'   => [
                    ['extend' => 'create', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'export', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-default btn-sm no-corner',],
                ],
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'title',
            'color',
            'background_color'
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'entry_tagsdatatable_' . time();
    }
}
