<?php

use Illuminate\Database\Seeder;

class RolesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /*
         * Role Types
         *
         */
        $RoleItems = [
            [
                'name'        => 'MasterAdmin',
                'slug'        => 'masteradmin',
                'description' => 'Master Admin Role',
                'level'       => 10,
            ],
            [
                'name'        => 'Admin',
                'slug'        => 'admin',
                'description' => 'Admin Role',
                'level'       => 9,
            ],
            [
                'name'        => 'ProductionManager',
                'slug'        => 'production',
                'description' => 'Production Manager Role',
                'level'       => 8,
            ],
            [
                'name'        => 'Packing & Store Manager',
                'slug'        => 'packingstoremanager',
                'description' => 'Production & Store Manager Role',
                'level'       => 7,
            ],
            [
                'name'        => 'Sales Manager',
                'slug'        => 'salesmanager',
                'description' => 'Sales Manager Role',
                'level'       => 6,
            ],
            [
                'name'        => 'Parcel Delivery Manager',
                'slug'        => 'parceldeliverymanager',
                'description' => 'Parcel Delivery Manager Role',
                'level'       => 5,
            ],
            [
                'name'        => 'Purchase Manager',
                'slug'        => 'purchasemanager',
                'description' => 'Purchase Role',
                'level'       => 4,
            ],
        ];

        /*
         * Add Role Items
         *
         */
        foreach ($RoleItems as $RoleItem) {
            $newRoleItem = config('roles.models.role')::where('slug', '=', $RoleItem['slug'])->first();
            if ($newRoleItem === null) {
                $newRoleItem = config('roles.models.role')::create([
                    'name'          => $RoleItem['name'],
                    'slug'          => $RoleItem['slug'],
                    'description'   => $RoleItem['description'],
                    'level'         => $RoleItem['level'],
                ]);
            }
        }

        $user = \App\Models\User::where('username','=','pradeep.p28')->first();
        echo "user ".$user;
        $newRoleItem = config('roles.models.role')::where('slug', '=', 'masteradmin')->first();
        $newRoleItem1 = config('roles.models.role')::where('slug', '=', 'admin')->first();
        echo "role ".$newRoleItem;
        $user->attachRole($newRoleItem);
        $user->attachRole($newRoleItem1);
        echo 'role attached';


        $newUser = App\Models\User::where('username','=','pradeep.p28')->first();
        $prakash = App\Models\User::where('username','=','prakash.g')->first();
        $sandeep = App\Models\User::where('username','=','sandeep.p16')->first();
        $ram = App\Models\User::where('username','=','ram.a11')->first();
        $mangal = App\Models\User::where('username','=','mangal.s')->first();

        $madminRole = config('roles.models.role')::where('slug', '=', 'masteradmin')->first();
        $adminRole = config('roles.models.role')::where('slug', '=', 'admin')->first();
        $productionManager = config('roles.models.role')::where('slug', '=', 'production')->first();
        $packingStoreManager = config('roles.models.role')::where('slug', '=', 'packingstoremanager')->first();
        
        //$newUser->attachRole($madminRole);
        $sandeep->attachRole($adminRole);
        $ram->attachRole($adminRole);
        $prakash->attachRole($productionManager);
        $prakash->attachRole($packingStoreManager);
        $mangal->attachRole($packingStoreManager);
        $mangal->attachRole($productionManager);
    }
}
