<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bonds', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_print')->nullable(true);
            $table->enum('machine_type', CreateUsersTable::f(config('app_data.machine_type_enum')));
            $table->enum('stone_type', CreateUsersTable::f(config('app_data.stone_type_enum')));
            $table->string('bond_short_description')->nullable(true);
            $table->enum('status',CreateUsersTable::f(config('app_data.status_enum')))->default('ACTIVE');
            
            
           
          

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
            //$table->foreign('deleted_by')->references('id')->on('users');    


            $table->timestamps();
            //$table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bonds');
    }
}
