<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class ConsumableCategory
 * @package App\Models
 * @version October 13, 2019, 7:26 pm UTC
 *
 */
class ConsumableCategory extends CRUDAwareModel
{
    //use SoftDeletes;
    use HasTranslations;


    public $table = 'consumable_categories';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name'
    ];


    public $translatable = ['name'];



    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name.*' => 'required|unique_translation:consumable_categories',
    ];

    public static $updateRules = [
        'name.*' => 'required|unique_translation:consumable_categories',
    ];



    
}
