<?php 

namespace App\Http\Resources\Production;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;
use App\Http\Resources\Bond\BondProcessResource;
use App\Http\Resources\Bond\BondProductResource;

class ProductionStatusResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $status = $this->status;
        $array = [
            'name' => $status->name,
            'tag' => $status->tag,
            'created_at' => \App\Http\Resources\ResourceHelper::formatDate($status->created_at)                     
        ];
        
        //$array = $this->base($array);
        return $array;
    }
}