<?php 

namespace App\Http\Resources\Production;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;
use App\Http\Resources\ResourceHelper;

class BondMaterialProductionResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $employee = $this->employee;
        if(!empty($employee)){
            $employee = new \App\Http\Resources\Employee\EmployeeResource($employee);
        }else{
            $employee = null;
        }

        $array = [
            'id' => $this->id,
            'material_id' => $this->material_id,
            'start_time' => ($this->start_time),
            'end_time' => ($this->end_time),
            'duration' => $this->duration,
            'mould' => $this->mould,
            'remaining_piece' => $this->remaining_piece,
            'electricity_out_duration' => $this->electricity_out_duration,
            'other_prod_blocker_duration' => $this->other_prod_blocker_duration,
            'other_blocker_reason' => $this->other_blocker_reason,
            'reason' => $this->reason,
            'bond_product' => $this->material->bondproduct->name,
            'employee' => new \App\Http\Resources\Employee\EmployeeResource($employee)
            //'status' => $this->getProductionStatus->status
        ];
        
        $array = $this->base($array);
        return $array;
    }
}