<?php 

namespace App\Http\Resources\Consumable;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class ConsumableSettingItemResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'qty' => $this->qty,
            'qty_type' => $this->qty_type,
            'expected_pcs' => $this->expected_pcs,
            'item' => new ConsumableItemResource($this->item)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}