<?php

namespace App\Http\Controllers;

use App\DataTables\BondMaterialRecipeDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondMaterialRecipeRequest;
use App\Http\Requests\UpdateBondMaterialRecipeRequest;
use App\Repositories\BondMaterialRecipeRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use App\Models\BondMaterialRecipe;
use Illuminate\Http\Request;

class BondMaterialRecipeController extends AppBaseController
{
    /** @var  BondMaterialRecipeRepository */
    private $bondMaterialRecipeRepository;

    public function __construct(BondMaterialRecipeRepository $bondMaterialRecipeRepo)
    {
        $this->bondMaterialRecipeRepository = $bondMaterialRecipeRepo;
    }

    /**
     * Display a listing of the BondMaterialRecipe.
     *
     * @param BondMaterialRecipeDataTable $bondMaterialRecipeDataTable
     * @return Response
     */
    public function index(BondMaterialRecipeDataTable $bondMaterialRecipeDataTable)
    {
        return $bondMaterialRecipeDataTable->render('bond_material_recipes.index');
    }

    /**
     * Show the form for creating a new BondMaterialRecipe.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_material_recipes.create');
    }

    
    /**
     * Store a newly created BondMaterialRecipe in storage.
     *
     * @param CreateBondMaterialRecipeRequest $request
     *
     * @return Response
     */
    public function store(CreateBondMaterialRecipeRequest $request)
    {
        $input = $request->all();
        
        $input = BondMaterialRecipe::filterEle($input, true);
        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->create($input);
        \App\Models\BondRecipeProductionStatus::updateProductionStatus($bondMaterialRecipe->material_id ,'READY_FOR_PRODUCTION');
        // $status = \App\Models\BondRecipeProductionStatus::where('material_id','=', $materialId)->orderBy('created_at','DESC')->first();
        // if($status->status->name == 'READY_FOR_PRODUCTION' || $status->status->name == 'STOPPED'){
            
        // }
        

        if($request->expectsJson()){
            return  $this->sendResponse( new \App\Http\Resources\Production\BondMaterialResource($bondMaterialRecipe), 'Bond Material created successfully.');
        }else{
            Flash::success('Bond Material Recipe saved successfully.');
            return redirect(route('bondMaterialRecipes.index'));
        }
    }

    /**
     * Display the specified BondMaterialRecipe.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id, Request $request)
    {
        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->find($id);

        $result = $this->checkEmpty($bondMaterialRecipe, $request);
        if($result){
            return $result;
        }

        if($request->expectsJson()){
            return  $this->sendDataResponse(new \App\Http\Resources\Production\BondMaterialResource($bondMaterialRecipe));
        }else{
            return view('bond_material_recipes.show')->with('recipe', $bondMaterialRecipe);
        }
    }

    /**
     * Show the form for editing the specified BondMaterialRecipe.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id, Request $request)
    {
        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->find($id);

        $result = $this->checkEmpty($bondMaterialRecipe, $request);
        if($result){
            return $result;
        }

        return view('bond_material_recipes.edit')->with('recipe', $bondMaterialRecipe);
    }

    /**
     * Update the specified BondMaterialRecipe in storage.
     *
     * @param  int              $id
     * @param UpdateBondMaterialRecipeRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondMaterialRecipeRequest $request)
    {
        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->find($id);

        $result = $this->checkEmpty($bondMaterialRecipe, $request);
        if($result){
            return $result;
        }

        $input = $request->all();
        $input = BondMaterialRecipe::filterEle($input, false);


        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->update($input, $id);

        if($request->expectsJson()){
            return  $this->sendResponse( new \App\Http\Resources\Production\BondMaterialResource($bondMaterialRecipe), 'Bond Material updated successfully.');
        }else{
            Flash::success('Bond Material Recipe updated successfully.');
            return redirect(route('bondMaterialRecipes.index'));
        }
        
    }

    /**
     * Remove the specified BondMaterialRecipe from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id,Request $request)
    {
        $bondMaterialRecipe = $this->bondMaterialRecipeRepository->whereOne('material_id','=', $id);

        $result = $this->checkEmpty($bondMaterialRecipe, $request);
        if($result){
            return $result;
        }

        $this->bondMaterialRecipeRepository->delete($id);

        if($request->expectsJson()){
            return  $this->sendResponseMessage('Bond Material deleted successfully.');;
        }else{
            Flash::success('Bond Material Recipe deleted successfully.');
            return redirect(route('bondMaterialRecipes.index'));
        }
    }

    private function  checkEmpty($bondMaterialRecipe , $request){
        if (empty($bondMaterialRecipe)){
            if($request->expectsJson()){
                return $this->sendValidationError('Material Recipe not found');
            }else{
                Flash::error('Bond Material Recipe not found');
                return redirect(route('bondMaterialRecipes.index'));
            }
        }
        return null;
    }
}
